﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Measurement
{
    public partial class Measurements : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductMeasurementList(string.Empty);
            }
        }

        private void BindProductMeasurementList(string searchWord)
        {
            List<ProductMeasurement> pbList = ProductMeasurementBL.GetList(Guid.Empty, searchWord);
            pbList = (from pb in pbList
                      where pb.IsActive
                      orderby pb.MeasurementName ascending
                      select pb).ToList<ProductMeasurement>();
            grdProductMeasurement.DataSource = pbList;//.OrderBy(reg => reg.SequenceNo);
            grdProductMeasurement.DataBind();

            if (pbList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product Measurement found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductMeasurementList(string.Empty);
            Master.ExportToExcel<Entities.ProductMeasurement>(grdProductMeasurement, "SizeReport");
        }

        protected void grdProductMeasurement_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProductMeasurement.PageIndex = e.NewPageIndex;
            BindProductMeasurementList(txtSearch.Text.Trim());
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductMeasurementList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductMeasurementList(string.Empty);
        }
    }
}